/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Comparator;

public class ChunkPosComparator
implements Comparator<hlc.a> {
    private int chunkPosX;
    private int chunkPosZ;
    private double yawRad;
    private double pitchNorm;

    public ChunkPosComparator(int chunkPosX, int chunkPosZ, double yawRad, double pitchRad) {
        this.chunkPosX = chunkPosX;
        this.chunkPosZ = chunkPosZ;
        this.yawRad = yawRad;
        this.pitchNorm = 1.0 - bfh.a((double)(Math.abs(pitchRad) / 1.5707963267948966), (double)0.0, (double)1.0);
    }

    @Override
    public int compare(hlc.a rs1, hlc.a rs2) {
        int cp1x = rs1.getSectionPosition().a();
        int cp1z = rs1.getSectionPosition().c();
        int cp2x = rs2.getSectionPosition().a();
        int cp2z = rs2.getSectionPosition().c();
        int distSq1 = this.getDistSq(cp1x, cp1z);
        int distSq2 = this.getDistSq(cp2x, cp2z);
        return distSq1 - distSq2;
    }

    private int getDistSq(int cpx, int cpz) {
        int dx = cpx - this.chunkPosX;
        int dz = cpz - this.chunkPosZ;
        int distSq = dx * dx + dz * dz;
        double yaw = bfh.d((double)dz, (double)dx);
        double dYaw = Math.abs(yaw - this.yawRad);
        if (dYaw > Math.PI) {
            dYaw = Math.PI * 2 - dYaw;
        }
        distSq = (int)((double)distSq * (0.2 + this.pitchNorm * dYaw));
        return distSq;
    }
}

