/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.CustomStaticModels;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.RendererUtils;
import net.optifine.entity.model.Renderers;
import net.optifine.entity.model.VirtualEntityRenderer;
import net.optifine.entity.model.anim.IModelRendererVariable;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IModelVariable;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.entity.model.anim.ModelVariableUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.util.ArrayUtils;
import net.optifine.util.DebugUtils;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<cee, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<egi, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Renderers originalRenderers;
    private static List<egi> customBlockEntityTypes;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        if (originalRenderers == null) {
            originalRenderers = Renderers.collectRenderers();
        }
        active = false;
        originalRenderers.restoreRenderers();
        CustomStaticModels.clear();
        customBlockEntityTypes.clear();
        his.CACHED_TYPES.clear();
        if (fzz.W().r != null) {
            Iterable entities = fzz.W().r.f();
            for (cdv entity : entities) {
                Map modelVariables = entity.aC().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        Map modelLocations = CustomEntityModels.getModelLocations();
        for (String name : modelLocations.keySet()) {
            amj loc = (amj)modelLocations.get(name);
            Config.dbg((String)("CustomEntityModel: " + name + ", model: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((String)name, (amj)loc, (RendererCache)rendererCache, (int)0);
            if (rc == null) continue;
            if (rc instanceof hnx) {
                hnx er = (hnx)rc;
                type = (cee)rc.getType().getLeft().get();
                CustomEntityModels.getEntityRenderMap().put(type, er);
                rendererCache.put(type, 0, er);
            } else if (rc instanceof his) {
                his ber = (his)rc;
                type = (egi)rc.getType().getRight().get();
                CustomEntityModels.getBlockEntityRenderMap().put(type, ber);
                rendererCache.put((egi)type, 0, ber);
                customBlockEntityTypes.add(type);
            } else if (rc instanceof VirtualEntityRenderer) {
                VirtualEntityRenderer ver = (VirtualEntityRenderer)rc;
                ver.register();
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
                continue;
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String[] aliases = CustomModelRegistry.getAliases((String)name);
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            String[] fileNames = CustomEntityModels.makeNameVariants((String)name, (String[])aliases);
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (String[])fileNames, (RandomEntityContext.Models)context);
            if (props == null) continue;
            if (type != null && type.getLeft().isPresent()) {
                mapEntityProperties.put((cee)type.getLeft().get(), props);
            }
            if (type == null || !type.getRight().isPresent()) continue;
            mapBlockEntityProperties.put((egi)type.getRight().get(), props);
        }
    }

    private static String[] makeNameVariants(String baseName, String[] aliases) {
        ArrayList<Object> variants = new ArrayList<Object>();
        aliases = ArrayUtils.normalize((String[])aliases);
        String[] names = (String[])ArrayUtils.addObjectToArray((Object[])aliases, (Object)baseName, (int)0);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            variants.add(name);
            variants.add(name + "/" + name);
        }
        String[] vars = variants.toArray(new String[variants.size()]);
        return vars;
    }

    private static RandomEntityProperties makeProperties(String name, String[] fileNames, RandomEntityContext.Models context) {
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (String)fileName, (RandomEntityContext.Models)context);
            if (props == null) continue;
            return props;
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(String name, String fileName, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        amj locJem = new amj("optifine/cem/" + name + ".jem");
        amj locProps = new amj("optifine/cem/" + name + ".properties");
        if (Config.hasResource((amj)locProps) && (props = RandomEntityProperties.parse((amj)locProps, (amj)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((amj)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((amj)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(name, locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    public static Map<cee, hnx> getEntityRenderMap() {
        return RendererUtils.getEntityRenderMap();
    }

    public static Map<egi, his> getBlockEntityRenderMap() {
        return RendererUtils.getBlockEntityRenderMap();
    }

    public static Map<ecm.a, gxi> getSkullModelMap() {
        return RendererUtils.getSkullModelMap();
    }

    private static Map<String, amj> getModelLocations() {
        String[] names;
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        LinkedHashMap<String, amj> resources = new LinkedHashMap<String, amj>();
        block0: for (String name : names = CustomModelRegistry.getModelNames()) {
            String path = prefix + name + suffix;
            amj loc = new amj(path);
            if (debugModels) {
                resources.put(name, loc);
                continue;
            }
            if (Config.hasResource((amj)loc)) {
                resources.put(name, loc);
                continue;
            }
            String[] aliases = CustomModelRegistry.getAliases((String)name);
            if (aliases == null) continue;
            for (String alias : aliases) {
                String pathAlias = prefix + alias + suffix;
                amj locAlias = new amj(pathAlias);
                if (!Config.hasResource((amj)locAlias)) continue;
                Config.log((String)("CustomEntityModel alias: " + name + " -> " + alias));
                resources.put(name, locAlias);
                continue block0;
            }
        }
        return resources;
    }

    public static IEntityRenderer parseEntityRender(String name, amj location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((amj)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((amj)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((String)name, (String)location.a(), (JsonObject)jo, (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + String.valueOf(location)), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(amj loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        gwg model = ma.makeModel();
        Object[] colors = dgn.values();
        colors = (dgn[])ArrayUtils.removeObjectFromArray((Object[])colors, (Object)dgn.p);
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            gyo part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            Object col = colors[(i + offset) % colors.length];
            amj locTexture = new amj("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(String name, String path, JsonObject obj, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        amj textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        gwg model = modelAdapter.makeModel();
        if (model == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (gwg)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (shadowSize >= 0.0f) {
            r.setShadowSize(shadowSize);
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (gwg)model, (IEntityRenderer)r, (amj)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, gwg model, IEntityRenderer er, amj textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof hpa) {
            model.locationTextureCustom = textureLocation;
            return;
        }
        if (model.isRenderRoot() && er.getType() != null) {
            model.h().setTextureLocation(textureLocation);
        } else {
            CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (gwg)model, (amj)textureLocation);
        }
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, gwg model, amj textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            gyo modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, gwg model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        int i;
        ArrayList<ModelVariableUpdater> listVariableUpdaters = new ArrayList<ModelVariableUpdater>();
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (gwg)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) {
                return false;
            }
            if (cmr.getModelRenderer().getModelUpdater() == null) continue;
            listVariableUpdaters.addAll(Arrays.asList(cmr.getModelRenderer().getModelUpdater().getModelVariableUpdaters()));
        }
        ModelVariableUpdater[] mvus = listVariableUpdaters.toArray(new ModelVariableUpdater[listVariableUpdaters.size()]);
        ModelUpdater globvalUpdater = new ModelUpdater(mvus);
        for (i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (cmr.getModelRenderer().getModelUpdater() == null) continue;
            cmr.getModelRenderer().setModelUpdater(globvalUpdater);
        }
        for (i = 0; i < mvus.length; ++i) {
            ModelVariableUpdater mvu = mvus[i];
            IModelVariable mv = mvu.getModelVariable();
            if (!(mv instanceof IModelRendererVariable)) continue;
            IModelRendererVariable mrv = (IModelRendererVariable)mv;
            mrv.getModelRenderer().setModelUpdater(globvalUpdater);
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, gwg model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        gyo parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            if (modelAdapter.isModelRendererOptional(modelPart)) {
                return true;
            }
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + DebugUtils.getClassName((Object)model) + ", modelName: " + modelAdapter.getName()));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                gyo[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    gyo mr = (gyo)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(ejm blockStateIn) {
        for (int i = 0; i < customBlockEntityTypes.size(); ++i) {
            egi type = (egi)customBlockEntityTypes.get(i);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(gmj screen) {
        gul customBookModel = CustomStaticModels.getBookModel();
        if (customBookModel != null && screen instanceof gom) {
            gom es = (gom)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static hnx getEntityRenderer(cdv entityIn, hnx renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((cdv)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.ax());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier2 = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier2 instanceof hnx)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        hnx er = (hnx)ier2;
        return er;
    }

    public static his getBlockEntityRenderer(egg entityIn, his renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((egg)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.s());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier2 = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier2 instanceof his)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        his ber = (his)ier2;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        customBlockEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

