/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements dqr {
    private final hkx chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private ejm[] blockStates;
    private dst[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(ejm.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(dst.class, 16);

    public ChunkCacheOF(hkx chunkCache, kd sectionPos) {
        this.chunkCache = chunkCache;
        int minChunkX = sectionPos.u() - 1;
        int minChunkY = sectionPos.v() - 1;
        int minChunkZ = sectionPos.w() - 1;
        int maxChunkX = sectionPos.u() + 1;
        int maxChunkY = sectionPos.v() + 1;
        int maxChunkZ = sectionPos.w() + 1;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(ja pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(drz type, ja pos) {
        return this.chunkCache.a(type, pos);
    }

    public ejm a_(ja pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        ejm iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (ejm[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (dst[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        elv chunk = this.chunkCache.getLevelChunk(kd.a((int)this.posX) + 1, kd.a((int)this.posY) + 1, kd.a((int)this.posZ) + 1);
        BlockPosM pos = new BlockPosM();
        for (int y = 16; y < 32; ++y) {
            int dy = y * this.sizeXZ;
            for (int z2 = 16; z2 < 32; ++z2) {
                int dz = z2 * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    ejm bs;
                    pos.setXyz(this.posX + x, this.posY + y, this.posZ + z2);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((ja)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int getCombinedLight(ejm blockStateIn, dqr worldIn, ja blockPosIn) {
        if (blockStateIn.hasEmissive()) {
            return LightCacheOF.getPackedLightRaw((dqr)worldIn, (ejm)blockStateIn, (ja)blockPosIn);
        }
        int index = this.getPositionIndex(blockPosIn);
        if (index < 0 || index >= this.combinedLights.length || this.combinedLights == null) {
            return LightCacheOF.getPackedLightRaw((dqr)worldIn, (ejm)blockStateIn, (ja)blockPosIn);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = LightCacheOF.getPackedLightRaw((dqr)worldIn, (ejm)blockStateIn, (ja)blockPosIn);
        }
        return light;
    }

    public dst getBiome(ja pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        dst biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public egg c_(ja pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean h(ja pos) {
        return this.chunkCache.h(pos);
    }

    public fga b_(ja pos) {
        return this.a_(pos).y();
    }

    public int a(ja blockPosIn, dra colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public ffp E_() {
        return this.chunkCache.E_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(jg directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int N_() {
        return this.chunkCache.N_();
    }

    public int M_() {
        return this.chunkCache.M_();
    }
}

