/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.optifine.util.BufferUtil;
import net.optifine.util.GlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BufferUtil {
    public static String getBufferHex(ftv bb) {
        return BufferUtil.getBufferHex((ByteBuffer)bb.getByteBuffer(), (int)bb.getStartPosition(), (VertexFormat.b)bb.getDrawMode(), (VertexFormat)bb.getVertexFormat(), (int)bb.getVertexCount());
    }

    public static String getBufferHex(ftz md2) {
        ftw.a res = md2.getVertexResult();
        ftz.a ds = md2.c();
        return BufferUtil.getBufferHex((ByteBuffer)res.a(), (int)0, (VertexFormat.b)ds.d(), (VertexFormat)ds.a(), (int)ds.b());
    }

    public static String getBufferHex(ByteBuffer buf, int startPos, VertexFormat.b drawMode, VertexFormat vf, int vertexCount) {
        String primitiveName = "";
        int vertexPerPrimitive = -1;
        if (drawMode == VertexFormat.b.h) {
            primitiveName = "quad";
            vertexPerPrimitive = 4;
        } else if (drawMode == VertexFormat.b.e) {
            primitiveName = "triangle";
            vertexPerPrimitive = 3;
        } else {
            return "Invalid draw mode: " + String.valueOf(drawMode);
        }
        StringBuffer sb = new StringBuffer();
        for (int v = 0; v < vertexCount; ++v) {
            if (v % vertexPerPrimitive == 0) {
                sb.append(primitiveName + " " + v / vertexPerPrimitive + "\n");
            }
            String vs = BufferUtil.getVertexHex((ByteBuffer)buf, (int)startPos, (VertexFormat)vf, (int)v);
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getVertexHex(ByteBuffer buf, int startPos, VertexFormat vf, int vertex) {
        StringBuffer sb = new StringBuffer();
        int pos = startPos + vertex * vf.getVertexSize();
        for (VertexFormatElement vfe : vf.getElements()) {
            if (vfe.getElementCount() > 0) {
                sb.append("(");
            }
            for (int i2 = 0; i2 < vfe.getElementCount(); ++i2) {
                if (i2 > 0) {
                    sb.append(" ");
                }
                switch (1.$SwitchMap$com$mojang$blaze3d$vertex$VertexFormatElement$Type[vfe.type().ordinal()]) {
                    case 1: {
                        sb.append(buf.getFloat(pos));
                        break;
                    }
                    case 2: 
                    case 3: {
                        sb.append(buf.get(pos));
                        break;
                    }
                    case 4: 
                    case 5: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    case 6: 
                    case 7: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    default: {
                        sb.append("??");
                    }
                }
                pos += vfe.type().size();
            }
            if (vfe.getElementCount() <= 0) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getBufferString(IntBuffer buf) {
        if (buf == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(pos=" + buf.position() + " lim=" + buf.limit() + " cap=" + buf.capacity() + ")");
        sb.append("[");
        int len = Math.min(buf.limit(), 1024);
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(buf.get(i2));
        }
        sb.append("]");
        return sb.toString();
    }

    public static int[] toArray(IntBuffer buf) {
        int[] arr = new int[buf.limit()];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = buf.get(i2);
        }
        return arr;
    }

    public static FloatBuffer createDirectFloatBuffer(int capacity) {
        return GlUtil.allocateMemory((int)(capacity << 2)).asFloatBuffer();
    }

    public static void fill(FloatBuffer buf, float val) {
        buf.clear();
        for (int i2 = 0; i2 < buf.capacity(); ++i2) {
            buf.put(i2, val);
        }
        buf.clear();
    }

    public static void copyFull(FloatBuffer src, FloatBuffer dst2) {
        src.position(0);
        dst2.position(0);
        dst2.put(src);
        src.position(0);
        dst2.position(0);
    }
}

