/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.RandomEntityRule;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<amj, amj> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private dgn[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final dgn[] COLORS_INVALID = new dgn[0];
    private static final amj ANVIL_GUI_TEXTURE = new amj("textures/gui/container/anvil.png");
    private static final amj BEACON_GUI_TEXTURE = new amj("textures/gui/container/beacon.png");
    private static final amj BREWING_STAND_GUI_TEXTURE = new amj("textures/gui/container/brewing_stand.png");
    private static final amj CHEST_GUI_TEXTURE = new amj("textures/gui/container/generic_54.png");
    private static final amj CRAFTING_TABLE_GUI_TEXTURE = new amj("textures/gui/container/crafting_table.png");
    private static final amj HORSE_GUI_TEXTURE = new amj("textures/gui/container/horse.png");
    private static final amj DISPENSER_GUI_TEXTURE = new amj("textures/gui/container/dispenser.png");
    private static final amj ENCHANTMENT_TABLE_GUI_TEXTURE = new amj("textures/gui/container/enchanting_table.png");
    private static final amj FURNACE_GUI_TEXTURE = new amj("textures/gui/container/furnace.png");
    private static final amj HOPPER_GUI_TEXTURE = new amj("textures/gui/container/hopper.png");
    private static final amj INVENTORY_GUI_TEXTURE = new amj("textures/gui/container/inventory.png");
    private static final amj SHULKER_BOX_GUI_TEXTURE = new amj("textures/gui/container/shulker_box.png");
    private static final amj VILLAGER_GUI_TEXTURE = new amj("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static dgn[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        dgn[] cols = new dgn[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            dgn col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static dgn parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        dgn[] colors = dgn.values();
        for (int i = 0; i < colors.length; ++i) {
            dgn enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static amj parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new amj(basePath + "/" + (String)tex);
    }

    private static Map<amj, amj> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<amj, amj> map = new HashMap<amj, amj>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            amj locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            amj locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            amj locKey = new amj(path);
            amj locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static amj getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container.ordinal()) {
            case 0: {
                return ANVIL_GUI_TEXTURE;
            }
            case 1: {
                return BEACON_GUI_TEXTURE;
            }
            case 2: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 3: {
                return CHEST_GUI_TEXTURE;
            }
            case 4: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 12: {
                return null;
            }
            case 5: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 6: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 7: {
                return FURNACE_GUI_TEXTURE;
            }
            case 8: {
                return HOPPER_GUI_TEXTURE;
            }
            case 9: {
                return HORSE_GUI_TEXTURE;
            }
            case 13: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 11: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 10: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, ja pos, drt blockAccess) {
        dst biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((dst)(biome = (dst)blockAccess.v(pos).a()), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, ja pos, drt blockAccess, gmj screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((gmj)screen))) {
            return false;
        }
        switch (ec.ordinal()) {
            case 1: {
                return this.matchesBeacon(pos, (dqr)blockAccess);
            }
            case 3: {
                return this.matchesChest(pos, (dqr)blockAccess);
            }
            case 5: {
                return this.matchesDispenser(pos, (dqr)blockAccess);
            }
            case 11: {
                return this.matchesShulker(pos, (dqr)blockAccess);
            }
        }
        return true;
    }

    public static String getName(gmj screen) {
        xx itc = screen.q();
        if (itc == null) {
            return null;
        }
        return itc.getString();
    }

    private boolean matchesBeacon(ja pos, dqr blockAccess) {
        egg te = blockAccess.c_(pos);
        if (!(te instanceof egb)) {
            return false;
        }
        egb teb = (egb)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(ja pos, dqr blockAccess) {
        egg te = blockAccess.c_(pos);
        if (te instanceof ego) {
            ego tec = (ego)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof ehf) {
            ehf teec = (ehf)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(ego tec, ja pos, dqr blockAccess) {
        ejm blockState = blockAccess.a_(pos);
        eke chestType = blockState.b((ekp)dvz.d) ? (eke)blockState.c((ekp)dvz.d) : eke.a;
        boolean isLarge = chestType != eke.a;
        boolean isTrapped = tec instanceof eii;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(ehf teec, ja pos, dqr blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(ja pos, dqr blockAccess) {
        EnumVariant var;
        egg te = blockAccess.c_(pos);
        if (!(te instanceof ehc)) {
            return false;
        }
        ehc ted = (ehc)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(ehc ted) {
        if (ted instanceof ehd) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(ja pos, dqr blockAccess) {
        dgn col;
        egg te = blockAccess.c_(pos);
        if (!(te instanceof ehw)) {
            return false;
        }
        ehw tesb = (ehw)te;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.w()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, cdv entity, drt blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.dF(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cV())) {
            return false;
        }
        switch (ec.ordinal()) {
            case 10: {
                return this.matchesVillager(entity, (dqr)blockAccess);
            }
            case 9: {
                return this.matchesHorse(entity, (dqr)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(cdv entity, dqr blockAccess) {
        int level;
        cyy vd;
        cza vp;
        if (!(entity instanceof cyx)) {
            return false;
        }
        cyx entityVillager = (cyx)entity;
        return this.professions == null || MatchProfession.matchesOne((cza)(vp = (cza)(vd = entityVillager.gR()).b().a()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(cdv entity, dqr blockAccess) {
        ctk el;
        dgn col;
        EnumVariant var;
        if (!(entity instanceof cth)) {
            return false;
        }
        cth ah = (cth)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof ctk) || Config.equalsOne((Object)(col = RandomEntityRule.getLlamaColor((ctk)(el = (ctk)ah))), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(cth entity) {
        if (entity instanceof ctj) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof cti) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof ctm) {
            return EnumVariant.MULE;
        }
        if (entity instanceof ctk) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public amj getTextureLocation(amj loc) {
        amj locNew = (amj)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + String.valueOf(this.container) + ", textures: " + String.valueOf(this.textureLocations);
    }
}

