/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.optifine.Config;
import net.optifine.CustomItemProperties;
import net.optifine.config.IParserInt;
import net.optifine.config.NbtTagValue;
import net.optifine.config.ParserEnchantmentId;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.render.Blender;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ItemUtils;
import net.optifine.util.Json;
import net.optifine.util.PathUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomItemProperties {
    public String name = null;
    public String basePath = null;
    public int type = 1;
    public int[] items = null;
    public String texture = null;
    public Map<String, String> mapTextures = null;
    public String model = null;
    public Map<String, String> mapModels = null;
    public RangeListInt damage = null;
    public boolean damagePercent = false;
    public int damageMask = 0;
    public RangeListInt stackSize = null;
    public int[] enchantmentIds = null;
    public RangeListInt enchantmentLevels = null;
    public NbtTagValue[] nbtTagValues = null;
    public int hand = 0;
    public int blend = 1;
    public float speed = 0.0f;
    public float rotation = 0.0f;
    public int layer = 0;
    public float duration = 1.0f;
    public int weight = 0;
    public amj textureLocation = null;
    public Map mapTextureLocations = null;
    public ico sprite = null;
    public Map mapSprites = null;
    public hyp bakedModelTexture = null;
    public Map<String, hyp> mapBakedModelsTexture = null;
    public hyp bakedModelFull = null;
    public Map<String, hyp> mapBakedModelsFull = null;
    public Set<amj> modelSpriteLocations = null;
    private int textureWidth = 0;
    private int textureHeight = 0;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_ENCHANTMENT = 2;
    public static final int TYPE_ARMOR = 3;
    public static final int TYPE_ELYTRA = 4;
    public static final int HAND_ANY = 0;
    public static final int HAND_MAIN = 1;
    public static final int HAND_OFF = 2;
    public static final String INVENTORY = "inventory";
    private static final String PREFIX_NBT = "nbt.";
    private static final String PREFIX_COMPONENTS = "components.";
    private static final String[] SUBTEXTURE_PREFIXES = new String[]{"bow", "brush", "crossbow", "elytra", "fishing_rod", "shield", "spyglass", "trident"};

    public CustomItemProperties(Properties props, String path) {
        this.name = CustomItemProperties.parseName((String)path);
        this.basePath = CustomItemProperties.parseBasePath((String)path);
        this.type = this.parseType(props.getProperty("type"));
        this.items = this.parseItems(props.getProperty("items"), props.getProperty("matchItems"));
        this.mapModels = CustomItemProperties.parseModels((Properties)props, (String)this.basePath);
        this.model = CustomItemProperties.parseModel((String)props.getProperty("model"), (String)path, (String)this.basePath, (int)this.type, (Map)this.mapModels);
        this.mapTextures = CustomItemProperties.parseTextures((Properties)props, (String)this.basePath);
        boolean textureFromPath = this.mapModels == null && this.model == null;
        this.texture = CustomItemProperties.parseTexture((String)props.getProperty("texture"), (String)props.getProperty("tile"), (String)props.getProperty("source"), (String)path, (String)this.basePath, (int)this.type, (Map)this.mapTextures, (boolean)textureFromPath);
        String damageStr = props.getProperty("damage");
        if (damageStr != null) {
            this.damagePercent = damageStr.contains("%");
            damageStr = damageStr.replace("%", "");
            this.damage = this.parseRangeListInt(damageStr);
            this.damageMask = this.parseInt(props.getProperty("damageMask"), 0);
        }
        this.stackSize = this.parseRangeListInt(props.getProperty("stackSize"));
        this.enchantmentIds = this.parseInts(CustomItemProperties.getProperty((Properties)props, (String[])new String[]{"enchantmentIDs", "enchantments"}), (IParserInt)new ParserEnchantmentId());
        this.enchantmentLevels = this.parseRangeListInt(props.getProperty("enchantmentLevels"));
        this.nbtTagValues = this.parseNbtTagValues(props);
        this.hand = this.parseHand(props.getProperty("hand"));
        this.blend = Blender.parseBlend((String)props.getProperty("blend"));
        this.speed = this.parseFloat(props.getProperty("speed"), 0.0f);
        this.rotation = this.parseFloat(props.getProperty("rotation"), 0.0f);
        this.layer = this.parseInt(props.getProperty("layer"), 0);
        this.weight = this.parseInt(props.getProperty("weight"), 0);
        this.duration = this.parseFloat(props.getProperty("duration"), 1.0f);
    }

    private static String getProperty(Properties props, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String val = props.getProperty(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private static String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    private static String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    private int parseType(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("item")) {
            return 1;
        }
        if (str.equals("enchantment")) {
            return 2;
        }
        if (str.equals("armor")) {
            return 3;
        }
        if (str.equals("elytra")) {
            return 4;
        }
        Config.warn((String)("Unknown method: " + str));
        return 0;
    }

    private int[] parseItems(String str, String str2) {
        if (str == null) {
            str = str2;
        }
        if (str == null) {
            return null;
        }
        str = str.trim();
        TreeSet<Integer> setItemIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            dhl item = this.getItemByName(token);
            if (item == null) {
                Config.warn((String)("Item not found: " + token));
                continue;
            }
            int id = dhl.a((dhl)item);
            if (id < 0) {
                Config.warn((String)("Item ID not found: " + token));
                continue;
            }
            setItemIds.add(new Integer(id));
        }
        Integer[] integers = setItemIds.toArray(new Integer[setItemIds.size()]);
        int[] ints = new int[integers.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integers[i];
        }
        return ints;
    }

    private dhl getItemByName(String name) {
        amj loc = new amj(name);
        if (!mo.h.d(loc)) {
            return null;
        }
        dhl item = (dhl)mo.h.a(loc);
        return item;
    }

    private static String parseTexture(String texStr, String texStr2, String texStr3, String path, String basePath, int type, Map<String, String> mapTexs, boolean textureFromPath) {
        int pos2;
        String bowStandbyTex;
        if (texStr == null) {
            texStr = texStr2;
        }
        if (texStr == null) {
            texStr = texStr3;
        }
        if (texStr != null) {
            String png = ".png";
            if (texStr.endsWith(png)) {
                texStr = texStr.substring(0, texStr.length() - png.length());
            }
            texStr = CustomItemProperties.fixTextureName((String)texStr, (String)basePath);
            return texStr;
        }
        if (type == 3) {
            return null;
        }
        if (mapTexs != null && (bowStandbyTex = mapTexs.get("texture.bow_standby")) != null) {
            return bowStandbyTex;
        }
        if (!textureFromPath) {
            return null;
        }
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        str = CustomItemProperties.fixTextureName((String)str, (String)basePath);
        return str;
    }

    private static Map parseTextures(Properties props, String basePath) {
        String prefix = "texture.";
        Map mapProps = CustomItemProperties.getMatchingProperties((Properties)props, (String)prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixTextureName((String)val, (String)basePath);
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixTextureName(String iconName, String basePath) {
        if (!(((String)(iconName = TextureUtils.fixResourcePath((String)iconName, (String)basePath))).startsWith(basePath) || ((String)iconName).startsWith("textures/") || ((String)iconName).startsWith("optifine/"))) {
            iconName = basePath + "/" + (String)iconName;
        }
        if (((String)iconName).endsWith(".png")) {
            iconName = ((String)iconName).substring(0, ((String)iconName).length() - 4);
        }
        if (((String)iconName).startsWith("/")) {
            iconName = ((String)iconName).substring(1);
        }
        return iconName;
    }

    private static String parseModel(String modelStr, String path, String basePath, int type, Map<String, String> mapModelNames) {
        String bowStandbyModel;
        if (modelStr != null) {
            String json = ".json";
            if (modelStr.endsWith(json)) {
                modelStr = modelStr.substring(0, modelStr.length() - json.length());
            }
            modelStr = CustomItemProperties.fixModelName((String)modelStr, (String)basePath);
            return modelStr;
        }
        if (type == 3) {
            return null;
        }
        if (mapModelNames != null && (bowStandbyModel = mapModelNames.get("model.bow_standby")) != null) {
            return bowStandbyModel;
        }
        return modelStr;
    }

    private static Map parseModels(Properties props, String basePath) {
        String prefix = "model.";
        Map mapProps = CustomItemProperties.getMatchingProperties((Properties)props, (String)prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixModelName((String)val, (String)basePath);
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixModelName(String modelName, String basePath) {
        String json;
        boolean isVanilla;
        boolean bl = isVanilla = ((String)(modelName = TextureUtils.fixResourcePath((String)modelName, (String)basePath))).startsWith("block/") || ((String)modelName).startsWith("item/");
        if (!(((String)modelName).startsWith(basePath) || isVanilla || ((String)modelName).startsWith("optifine/"))) {
            modelName = basePath + "/" + (String)modelName;
        }
        if (((String)modelName).endsWith(json = ".json")) {
            modelName = ((String)modelName).substring(0, ((String)modelName).length() - json.length());
        }
        if (((String)modelName).startsWith("/")) {
            modelName = ((String)modelName).substring(1);
        }
        return modelName;
    }

    private int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int val = Config.parseInt((String)(str = str.trim()), (int)Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            Config.warn((String)("Invalid integer: " + str));
            return defVal;
        }
        return val;
    }

    private float parseFloat(String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        float val = Config.parseFloat((String)(str = str.trim()), (float)Float.MIN_VALUE);
        if (val == Float.MIN_VALUE) {
            Config.warn((String)("Invalid float: " + str));
            return defVal;
        }
        return val;
    }

    private int[] parseInts(String str, IParserInt parser) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)" ");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int val = parser.parse(token, Integer.MIN_VALUE);
            if (val == Integer.MIN_VALUE) {
                Config.warn((String)("Invalid value: " + token));
                continue;
            }
            list.add(val);
        }
        Integer[] intArr = list.toArray(new Integer[list.size()]);
        int[] ints = Config.toPrimitive((Integer[])intArr);
        return ints;
    }

    private RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)" ");
        RangeListInt rangeList = new RangeListInt();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            RangeInt range = this.parseRangeInt(token);
            if (range == null) {
                Config.warn((String)("Invalid range list: " + str));
                return null;
            }
            rangeList.addRange(range);
        }
        return rangeList;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        int countMinus = (str = str.trim()).length() - str.replace("-", "").length();
        if (countMinus > 1) {
            Config.warn((String)("Invalid range: " + str));
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)"- ");
        int[] vals = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int val = Config.parseInt((String)token, (int)-1);
            if (val < 0) {
                Config.warn((String)("Invalid range: " + str));
                return null;
            }
            vals[i] = val;
        }
        if (vals.length == 1) {
            int val = vals[0];
            if (str.startsWith("-")) {
                return new RangeInt(0, val);
            }
            if (str.endsWith("-")) {
                return new RangeInt(val, 65535);
            }
            return new RangeInt(val, val);
        }
        if (vals.length == 2) {
            int min = Math.min(vals[0], vals[1]);
            int max = Math.max(vals[0], vals[1]);
            return new RangeInt(min, max);
        }
        Config.warn((String)("Invalid range: " + str));
        return null;
    }

    private NbtTagValue[] parseNbtTagValues(Properties props) {
        Map mapComponents = CustomItemProperties.getMatchingProperties((Properties)props, (String)"components.");
        Map mapNbt = CustomItemProperties.getMatchingProperties((Properties)props, (String)"nbt.");
        Map mapNbtComponents = this.generateComponentsFromNbt(mapNbt);
        if (mapComponents.isEmpty()) {
            if (mapNbt.size() != mapNbtComponents.size()) {
                return new NbtTagValue[0];
            }
            mapComponents.putAll(mapNbtComponents);
            if (mapComponents.isEmpty()) {
                return null;
            }
        }
        ArrayList<NbtTagValue> listNbts = new ArrayList<NbtTagValue>();
        for (Map.Entry entry : mapComponents.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String id = key.substring("components.".length());
            id = this.fixNamespaces(id);
            NbtTagValue nbt = new NbtTagValue(id, val);
            listNbts.add(nbt);
        }
        NbtTagValue[] nbts = listNbts.toArray(new NbtTagValue[listNbts.size()]);
        return nbts;
    }

    private Map<String, String> generateComponentsFromNbt(Map<String, String> mapNbt) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : mapNbt.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            String id = key.substring("nbt.".length());
            int mapSizePrev = map.size();
            if (id.equals("display.Name")) {
                map.putIfAbsent("components.minecraft:custom_name", val);
            } else if (id.equals("display.Lore")) {
                map.putIfAbsent("components.minecraft:lore", val);
            } else if (id.equals("Potion")) {
                map.putIfAbsent("components.minecraft:potion_contents.potion", val);
            }
            if (id.equals("Damage")) {
                map.putIfAbsent("components.minecraft:damage", val);
            }
            if (id.equals("Variant") && this.type == 1 && ArrayUtils.contains((int[])this.items, (int)dhl.a((dhl)dht.sv))) {
                map.putIfAbsent("components.minecraft:bucket_entity_data.Variant", val);
            }
            if (map.size() > mapSizePrev) {
                Config.warn((String)("Deprecated NBT check: " + key + "=" + val));
                continue;
            }
            Config.warn((String)("Invalid NBT check: " + key + "=" + val));
        }
        return map;
    }

    private String fixNamespaces(String id) {
        int posNameEnd;
        if (((String)(id = ((String)id).replace("~", "minecraft:"))).startsWith("*")) {
            return id;
        }
        int posPoint = ((String)id).indexOf(46);
        int n = posNameEnd = posPoint >= 0 ? posPoint : ((String)id).length();
        if (((String)id).indexOf(58, 0, posNameEnd) < 0) {
            id = "minecraft:" + (String)id;
        }
        return id;
    }

    private static Map<String, String> getMatchingProperties(Properties props, String keyPrefix) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String val = props.getProperty(string);
            if (!string.startsWith(keyPrefix)) continue;
            map.put(string, val);
        }
        return map;
    }

    private int parseHand(String str) {
        if (str == null) {
            return 0;
        }
        if ((str = str.toLowerCase()).equals("any")) {
            return 0;
        }
        if (str.equals("main")) {
            return 1;
        }
        if (str.equals("off")) {
            return 2;
        }
        Config.warn((String)("Invalid hand: " + str));
        return 0;
    }

    public boolean isValid(String path) {
        if (this.name == null || this.name.length() <= 0) {
            Config.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            Config.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.type == 0) {
            Config.warn((String)("No type defined: " + path));
            return false;
        }
        if (this.type == 4 && this.items == null) {
            this.items = new int[]{dhl.a((dhl)dht.pq)};
        }
        if (this.type == 1 || this.type == 3 || this.type == 4) {
            if (this.items == null) {
                this.items = this.detectItems();
            }
            if (this.items == null) {
                Config.warn((String)("No items defined: " + path));
                return false;
            }
        }
        if (this.texture == null && this.mapTextures == null && this.model == null && this.mapModels == null) {
            Config.warn((String)("No texture or model specified: " + path));
            return false;
        }
        if (this.type == 2 && this.enchantmentIds == null) {
            Config.warn((String)("No enchantmentIDs specified: " + path));
            return false;
        }
        if (this.nbtTagValues != null && this.nbtTagValues.length == 0) {
            Config.warn((String)("Invalid NBT checks specified: " + path));
            return false;
        }
        return true;
    }

    private int[] detectItems() {
        dhl item = this.getItemByName(this.name);
        if (item == null) {
            return null;
        }
        int id = dhl.a((dhl)item);
        if (id < 0) {
            return null;
        }
        return new int[]{id};
    }

    public void registerIcons(icn textureMap) {
        if (this.texture != null) {
            this.textureLocation = this.getTextureLocation(this.texture);
            if (this.type == 1) {
                amj spriteLocation = this.getSpriteLocation(this.textureLocation);
                this.sprite = textureMap.registerSprite(spriteLocation);
            }
        }
        if (this.mapTextures != null) {
            this.mapTextureLocations = new HashMap();
            this.mapSprites = new HashMap();
            Set keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String val = (String)this.mapTextures.get(key);
                amj locTex = this.getTextureLocation(val);
                this.mapTextureLocations.put(key, locTex);
                if (this.type != 1) continue;
                amj locSprite = this.getSpriteLocation(locTex);
                ico icon = textureMap.registerSprite(locSprite);
                this.mapSprites.put(key, icon);
            }
        }
        for (amj loc : this.modelSpriteLocations) {
            textureMap.registerSprite(loc);
        }
    }

    public void updateIcons(icn textureMap) {
        if (this.sprite != null) {
            this.sprite = textureMap.a(this.sprite.getName());
        }
        if (this.mapSprites != null) {
            Set keySet = this.mapSprites.keySet();
            for (String key : keySet) {
                ico sprite = (ico)this.mapSprites.get(key);
                if (sprite == null) continue;
                amj loc = sprite.getName();
                ico spriteNew = textureMap.a(loc);
                if (spriteNew == null || icd.isMisingSprite((ico)spriteNew)) {
                    Config.warn((String)("Missing CIT sprite: " + String.valueOf(loc) + ", properties: " + this.basePath));
                }
                this.mapSprites.put(key, spriteNew);
            }
        }
    }

    private amj getTextureLocation(String texName) {
        String filePath;
        amj locFile;
        boolean exists;
        if (texName == null) {
            return null;
        }
        amj resLoc = new amj(texName);
        String domain = resLoc.b();
        Object path = resLoc.a();
        if (!((String)path).contains("/")) {
            path = "textures/item/" + (String)path;
        }
        if (!(exists = Config.hasResource((amj)(locFile = new amj(domain, filePath = (String)path + ".png"))))) {
            Config.warn((String)("File not found: " + filePath));
        }
        return locFile;
    }

    private amj getSpriteLocation(amj resLoc) {
        String pathTex = resLoc.a();
        pathTex = StrUtils.removePrefix((String)pathTex, (String)"textures/");
        pathTex = StrUtils.removeSuffix((String)pathTex, (String)".png");
        amj locTex = new amj(resLoc.b(), pathTex);
        return locTex;
    }

    public void updateModelTexture(icn textureMap, hht itemModelGenerator) {
        if (this.texture == null && this.mapTextures == null) {
            return;
        }
        String[] textures = this.getModelTextures();
        boolean useTint = this.isUseTint();
        this.bakedModelTexture = CustomItemProperties.makeBakedModel((icn)textureMap, (hht)itemModelGenerator, (String[])textures, (boolean)useTint);
        if (this.type == 1 && this.mapTextures != null) {
            Set keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String tex = (String)this.mapTextures.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"texture.");
                if (!this.isSubTexture(path)) continue;
                String[] texNames = new String[]{tex};
                hyj modelTex = CustomItemProperties.makeBakedModel((icn)textureMap, (hht)itemModelGenerator, (String[])texNames, (boolean)useTint);
                if (this.mapBakedModelsTexture == null) {
                    this.mapBakedModelsTexture = new HashMap();
                }
                String location = "item/" + path;
                this.mapBakedModelsTexture.put(location, modelTex);
            }
        }
    }

    private boolean isSubTexture(String path) {
        return StrUtils.startsWith((String)path, (String[])SUBTEXTURE_PREFIXES);
    }

    private boolean isUseTint() {
        return true;
    }

    private static hyj makeBakedModel(icn textureMap, hht itemModelGenerator, String[] textures, boolean useTint) {
        HashMap<Object, ier> mapMaterials = new HashMap<Object, ier>();
        amj atlasLoc = Config.getTextureMap().g();
        String modelName = "custom";
        for (int i = 0; i < textures.length; ++i) {
            String texture = textures[i];
            String spriteName = StrUtils.removePrefix((String)texture, (String)"textures/");
            amj spriteLoc = amj.b((String)spriteName);
            ier material = new ier(atlasLoc, spriteLoc);
            String key = "layer" + i;
            mapMaterials.put(key, material);
            if (i != 0) continue;
            modelName = texture;
            mapMaterials.put("particle", material);
        }
        hhz textureSlots = new hhz(mapMaterials);
        iew debugName = () -> ArrayUtils.arrayToString((Object[])textures);
        1 modelBaker = new /* Unavailable Anonymous Inner Class!! */;
        iel modelState = iel.a;
        List quads = hht.a((hhz)textureSlots, (ieu)modelBaker, (ifa)modelState, (iew)debugName).a();
        boolean blockLight = false;
        String spriteName = StrUtils.removePrefix((String)textures[0], (String)"textures/");
        amj spriteLoc = amj.b((String)spriteName);
        ico particleSprite = textureMap.getRegisteredSprite(spriteLoc);
        hhv transforms = hhv.a;
        hyu props = new hyu(blockLight, particleSprite, transforms);
        ArrayList tints = new ArrayList();
        amj modelLoc = amj.b((String)modelName);
        hyj model = new hyj(tints, quads, props, modelLoc);
        return model;
    }

    public static ico getSprite(ier material) {
        return Config.getTextureMap().a(material.b());
    }

    private String[] getModelTextures() {
        if (this.type == 1 && this.items.length == 1) {
            String material;
            boolean isPotionItem;
            dhl item = dhl.b((int)this.items[0]);
            boolean bl = isPotionItem = item == dht.up || item == dht.xy || item == dht.xB;
            if (isPotionItem && this.damage != null && this.damage.getCountRanges() > 0) {
                RangeInt range = this.damage.getRange(0);
                int valDamage = range.getMin();
                boolean splash = (valDamage & 0x4000) != 0;
                String texOverlay = this.getMapTexture(this.mapTextures, "texture.potion_overlay", "item/potion_overlay");
                String texMain = null;
                texMain = splash ? this.getMapTexture(this.mapTextures, "texture.potion_bottle_splash", "item/potion_bottle_splash") : this.getMapTexture(this.mapTextures, "texture.potion_bottle_drinkable", "item/potion_bottle_drinkable");
                return new String[]{texOverlay, texMain};
            }
            dqa equip = ItemUtils.getEquippable((dhl)item);
            if (equip != null && Config.equals((Object)(material = ItemUtils.getMaterial((dqa)equip)), (Object)"leather")) {
                String type = "helmet";
                cef equipmentSlot = equip.b();
                if (equipmentSlot == cef.f) {
                    type = "helmet";
                }
                if (equipmentSlot == cef.e) {
                    type = "chestplate";
                }
                if (equipmentSlot == cef.d) {
                    type = "leggings";
                }
                if (equipmentSlot == cef.c) {
                    type = "boots";
                }
                String key = material + "_" + type;
                String texMain = this.getMapTexture(this.mapTextures, "texture." + key, "item/" + key);
                String texOverlay = this.getMapTexture(this.mapTextures, "texture." + key + "_overlay", "item/" + key + "_overlay");
                return new String[]{texMain, texOverlay};
            }
        }
        return new String[]{this.texture};
    }

    private String getMapTexture(Map<String, String> map, String key, String def) {
        if (map == null) {
            return def;
        }
        String str = map.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    public String toString() {
        return this.basePath + "/" + this.name + ", type: " + this.type + ", items: [" + Config.arrayToString((int[])this.items) + "], texture: " + this.texture;
    }

    public float getTextureWidth(icq textureManager) {
        if (this.textureWidth <= 0) {
            if (this.textureLocation != null) {
                iby tex = textureManager.b(this.textureLocation);
                int texId = tex.getGlTextureId();
                int prevTexId = GlStateManager.getBoundTexture();
                GlStateManager._bindTexture((int)texId);
                this.textureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                GlStateManager._bindTexture((int)prevTexId);
            }
            if (this.textureWidth <= 0) {
                this.textureWidth = 16;
            }
        }
        return this.textureWidth;
    }

    public float getTextureHeight(icq textureManager) {
        if (this.textureHeight <= 0) {
            if (this.textureLocation != null) {
                iby tex = textureManager.b(this.textureLocation);
                int texId = tex.getGlTextureId();
                int prevTexId = GlStateManager.getBoundTexture();
                GlStateManager._bindTexture((int)texId);
                this.textureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                GlStateManager._bindTexture((int)prevTexId);
            }
            if (this.textureHeight <= 0) {
                this.textureHeight = 16;
            }
        }
        return this.textureHeight;
    }

    public hyp getBakedModel(amj modelLocation, boolean fullModel) {
        String modelPath;
        hyp customModel;
        Map mapBakedModels;
        hyp bakedModel;
        if (fullModel) {
            bakedModel = this.bakedModelFull;
            mapBakedModels = this.mapBakedModelsFull;
        } else {
            bakedModel = this.bakedModelTexture;
            mapBakedModels = this.mapBakedModelsTexture;
        }
        if (modelLocation != null && mapBakedModels != null && (customModel = (hyp)mapBakedModels.get(modelPath = modelLocation.a())) != null) {
            return customModel;
        }
        return bakedModel;
    }

    public void registerModels(Map<amj, ban> mapModelsIn, boolean checkParents) {
        Set locs = this.getModelLocations(checkParents);
        for (amj loc : locs) {
            amj locJson = this.getModelLocationJson(loc);
            if (mapModelsIn.containsKey(locJson)) continue;
            Optional opt = Config.getResourceSafe((amj)locJson);
            if (opt.isEmpty()) {
                Config.warn((String)("Model not found: " + String.valueOf(loc)));
                continue;
            }
            ban res = (ban)opt.get();
            mapModelsIn.put(locJson, res);
        }
    }

    public void collectModelSprites(Map<amj, ifg> mapModelsIn) {
        this.modelSpriteLocations = new LinkedHashSet();
        Set locs = this.getModelLocations(false);
        for (amj loc : locs) {
            ifg um = mapModelsIn.get(loc);
            if (um == null) {
                Config.warn((String)("Unbaked model not found: " + String.valueOf(loc)));
                continue;
            }
            this.collectModelSprites(um, loc);
        }
    }

    public Set<amj> getModelLocations(boolean checkParents) {
        LinkedHashSet<amj> set = new LinkedHashSet<amj>();
        if (this.model != null) {
            amj loc = CustomItemProperties.getModelLocation((String)this.model);
            this.addModelLocation(set, loc, checkParents);
        }
        if (this.type == 1 && this.mapModels != null) {
            Set keySet = this.mapModels.keySet();
            for (String key : keySet) {
                String mod = (String)this.mapModels.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"model.");
                if (!this.isSubTexture(path)) continue;
                amj loc = CustomItemProperties.getModelLocation((String)mod);
                this.addModelLocation(set, loc, checkParents);
            }
        }
        return set;
    }

    private void addModelLocation(Set<amj> set, amj loc, boolean checkParents) {
        if (set.contains(loc)) {
            return;
        }
        set.add(loc);
        if (!checkParents) {
            return;
        }
        amj locJson = this.getModelLocationJson(loc);
        Optional res = Config.getResourceSafe((amj)locJson);
        if (res.isEmpty()) {
            return;
        }
        try {
            JsonParser jp = new JsonParser();
            JsonObject json = (JsonObject)jp.parse((Reader)((ban)res.get()).e());
            String parent = Json.getString((JsonObject)json, (String)"parent");
            if (parent != null && !parent.startsWith("builtin/")) {
                parent = PathUtils.resolveRelative((String)parent, (String)this.basePath);
                amj locParent = CustomItemProperties.getModelLocation((String)parent);
                this.addModelLocation(set, locParent, checkParents);
            }
        }
        catch (Exception e) {
            Config.warn((String)("Error loading custom model: " + String.valueOf(locJson) + ", " + e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    public void updateModelsFull() {
        iez modelManager = Config.getModelManager();
        hyp missingModel = modelManager.getMissingItemModel();
        if (this.model != null) {
            amj locItem = CustomItemProperties.getItemLocation((String)this.model);
            this.bakedModelFull = modelManager.a(locItem);
            if (this.bakedModelFull == missingModel) {
                Config.warn((String)("Custom Items: Model not found " + locItem.toString()));
                this.bakedModelFull = null;
            }
        }
        if (this.type == 1 && this.mapModels != null) {
            Set keySet = this.mapModels.keySet();
            for (String key : keySet) {
                String mod = (String)this.mapModels.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"model.");
                if (!this.isSubTexture(path)) continue;
                amj locItem = CustomItemProperties.getItemLocation((String)mod);
                hyp bm = modelManager.a(locItem);
                if (bm == missingModel) {
                    Config.warn((String)("Custom Items: Model not found " + locItem.toString()));
                    continue;
                }
                if (this.mapBakedModelsFull == null) {
                    this.mapBakedModelsFull = new HashMap();
                }
                String location = "item/" + path;
                this.mapBakedModelsFull.put(location, bm);
            }
        }
    }

    private void collectModelSprites(ifg modelIn, amj locIn) {
        2 debugName = new /* Unavailable Anonymous Inner Class!! */;
    }

    private static amj getModelLocation(String name) {
        return new amj(name);
    }

    private amj getModelLocationJson(amj loc) {
        String path = StrUtils.addSuffixCheck((String)loc.a(), (String)".json");
        if (!(path = PathUtils.resolveRelative((String)path, (String)this.basePath)).startsWith("optifine/")) {
            path = StrUtils.addPrefixCheck((String)"models/", (String)path);
        }
        return loc.e(path);
    }

    private static amj getItemLocation(String modelName) {
        modelName = StrUtils.removePrefix((String)modelName, (String)"item/");
        amj loc = CustomItemProperties.getModelLocation((String)modelName);
        return loc;
    }
}

