/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private cdv entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<ja> setLitChunkPos = new HashSet();

    public DynamicLight(cdv entity) {
        this.entity = entity;
        this.offsetY = entity.df();
    }

    public void update(hfq renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dK() - 0.5;
        double posY = this.entity.dM() - 0.5 + this.offsetY;
        double posZ = this.entity.dQ() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((cdv)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            jg dirX = (bfh.a((double)posX) & 0xF) >= 8 ? jg.f : jg.e;
            jg dirY = (bfh.a((double)posY) & 0xF) >= 8 ? jg.b : jg.a;
            jg dirZ = (bfh.a((double)posZ) & 0xF) >= 8 ? jg.d : jg.c;
            long chunkPos = this.getChunkPos(posX, posY, posZ);
            hlc.a chunk = renderGlobal.getRenderChunk(chunkPos);
            long chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            hlc.a chunkX = renderGlobal.getRenderChunk(chunkPosX);
            long chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            hlc.a chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            long chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            hlc.a chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            long chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            hlc.a chunkY = renderGlobal.getRenderChunk(chunkPosY);
            long chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            hlc.a chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            long chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            hlc.a chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            long chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            hlc.a chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private long getChunkPos(double x, double y, double z2) {
        int cx = kd.a((int)bfh.a((double)x));
        int cy = kd.a((int)bfh.a((double)y));
        int cz = kd.a((int)bfh.a((double)z2));
        return kd.b((int)cx, (int)cy, (int)cz);
    }

    private long getChunkPos(hlc.a renderChunk, long pos, jg facing) {
        int x = kd.b((long)pos);
        int y = kd.c((long)pos);
        int z2 = kd.d((long)pos);
        return kd.b((int)(x += facing.j()), (int)(y += facing.k()), (int)(z2 += facing.l()));
    }

    private void updateChunkLight(hlc.a renderChunk, Set<ja> setPrevPos, Set<ja> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        hlb compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.isEmpty()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        ja pos = renderChunk.getPosition().j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(hfq renderGlobal) {
        for (ja posOld : this.setLitChunkPos) {
            hlc.a chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public cdv getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + String.valueOf(this.entity) + ", offsetY: " + this.offsetY;
    }
}

