/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipProvider;

public class TooltipManager {
    private gmj guiScreen;
    private TooltipProvider tooltipProvider;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public TooltipManager(gmj guiScreen, TooltipProvider tooltipProvider) {
        this.guiScreen = guiScreen;
        this.tooltipProvider = tooltipProvider;
    }

    public void drawTooltips(gdd graphicsIn, int x, int y, List<gdn> buttonList) {
        if (Math.abs(x - this.lastMouseX) > 5 || Math.abs(y - this.lastMouseY) > 5) {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
            return;
        }
        int activateDelay = 700;
        if (System.currentTimeMillis() < this.mouseStillTime + (long)activateDelay) {
            return;
        }
        gdn btn = GuiScreenOF.getSelectedButton((int)x, (int)y, buttonList);
        if (btn == null) {
            return;
        }
        Rectangle rect = this.tooltipProvider.getTooltipBounds(this.guiScreen, x, y);
        String[] lines = this.tooltipProvider.getTooltipLines(btn, rect.width);
        if (lines == null) {
            return;
        }
        if (lines.length > 8) {
            lines = Arrays.copyOf(lines, 8);
            int n2 = lines.length - 1;
            lines[n2] = lines[n2] + " ...";
        }
        if (this.tooltipProvider.isRenderBorder()) {
            int colBorder = -528449408;
            this.drawRectBorder(graphicsIn, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, colBorder);
        }
        graphicsIn.a(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, -536870912);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int col = -2236963;
            if (line.endsWith("!")) {
                col = -57312;
            }
            gda fontRenderer = fzz.W().g;
            graphicsIn.a(fontRenderer, line, rect.x + 5, rect.y + 5 + i * 11, col, true);
        }
    }

    private void drawRectBorder(gdd graphicsIn, int x1, int y1, int x2, int y2, int col) {
        graphicsIn.a(x1, y1 - 1, x2, y1, col);
        graphicsIn.a(x1, y2, x2, y2 + 1, col);
        graphicsIn.a(x1 - 1, y1, x1, y2, col);
        graphicsIn.a(x2, y1, x2 + 1, y2, col);
    }
}

