/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.optifine.Config;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.BlockAliases;
import net.optifine.shaders.Shaders;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;

/*
 * Exception performing whole class analysis ignored.
 */
public class SVertexBuilder {
    private VertexFormat vertexFormat;
    private int vertexSize;
    private int offsetNormal;
    private int offsetUV;
    private boolean hasNormal;
    private boolean hasUV;
    private long[] entityData = new long[10];
    private int entityDataIndex = 0;

    public SVertexBuilder() {
        this.entityData[this.entityDataIndex] = 0L;
    }

    public void pushEntity(long data) {
        ++this.entityDataIndex;
        this.entityData[this.entityDataIndex] = data;
    }

    public void popEntity() {
        this.entityData[this.entityDataIndex] = 0L;
        --this.entityDataIndex;
    }

    public static void pushEntity(ejm blockState, fud ivb) {
        if (!(ivb instanceof ftv)) {
            return;
        }
        ftv wrr = (ftv)ivb;
        int blockId = BlockAliases.getAliasBlockId((ejm)blockState);
        int metadata = BlockAliases.getAliasMetadata((ejm)blockState);
        int renderType = BlockAliases.getRenderType((ejm)blockState);
        int dataLo = ((renderType & 0xFFFF) << 16) + (blockId & 0xFFFF);
        int dataHi = metadata & 0xFFFF;
        wrr.sVertexBuilder.pushEntity(((long)dataHi << 32) + (long)dataLo);
    }

    public static void popEntity(fud ivb) {
        if (!(ivb instanceof ftv)) {
            return;
        }
        ftv wrr = (ftv)ivb;
        wrr.sVertexBuilder.popEntity();
    }

    public static boolean popEntity(boolean value, ftv wrr) {
        wrr.sVertexBuilder.popEntity();
        return value;
    }

    public static void endSetVertexFormat(ftv wrr) {
        VertexFormat vf;
        SVertexBuilder svb = wrr.sVertexBuilder;
        svb.vertexFormat = vf = wrr.getVertexFormat();
        svb.vertexSize = vf.getVertexSize() / 4;
        svb.hasNormal = vf.hasNormal();
        svb.hasUV = vf.hasUV(0);
        svb.offsetNormal = svb.hasNormal ? vf.getNormalOffset() / 4 : 0;
        svb.offsetUV = svb.hasUV ? vf.getUvOffsetById(0) / 4 : 0;
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public static void beginAddVertex(ftv wrr) {
        if (wrr.getVertexCount() == 0) {
            SVertexBuilder.endSetVertexFormat((ftv)wrr);
        }
    }

    public static void endAddVertex(ftv wrr) {
        if (Config.isMinecraftThread() && (hox.isRenderItemGui() || gjx.isRenderGui())) {
            return;
        }
        SVertexBuilder svb = wrr.sVertexBuilder;
        if (svb.vertexSize == 18) {
            if (wrr.getDrawMode() == VertexFormat.b.h && wrr.getVertexCount() % 4 == 0) {
                svb.calcNormal(wrr, wrr.getBufferIntSize() - 4 * svb.vertexSize);
            }
            long eData = svb.entityData[svb.entityDataIndex];
            int pos = wrr.getBufferIntSize() - 18 + 13;
            wrr.getIntBuffer().put(pos += wrr.getIntStartPosition(), (int)eData);
            wrr.getIntBuffer().put(pos + 1, (int)(eData >> 32));
        }
    }

    public static void beginAddVertexData(ftv wrr, int[] data) {
        if (wrr.getVertexCount() == 0) {
            SVertexBuilder.endSetVertexFormat((ftv)wrr);
        }
        SVertexBuilder svb = wrr.sVertexBuilder;
        if (svb.vertexSize == 18) {
            long eData = svb.entityData[svb.entityDataIndex];
            int pos = 13;
            while (pos + 1 < data.length) {
                data[pos] = (int)eData;
                data[pos + 1] = (int)(eData >> 32);
                pos += 18;
            }
        }
    }

    public static void beginAddVertexData(ftv wrr, ByteBuffer byteBuffer) {
        if (wrr.getVertexCount() == 0) {
            SVertexBuilder.endSetVertexFormat((ftv)wrr);
        }
        SVertexBuilder svb = wrr.sVertexBuilder;
        if (svb.vertexSize == 18) {
            long eData = svb.entityData[svb.entityDataIndex];
            int dataLengthInt = byteBuffer.limit() / 4;
            int posInt = 13;
            while (posInt + 1 < dataLengthInt) {
                int dataInt0 = (int)eData;
                int dataInt1 = (int)(eData >> 32);
                byteBuffer.putInt(posInt * 4, dataInt0);
                byteBuffer.putInt((posInt + 1) * 4, dataInt1);
                posInt += 18;
            }
        }
    }

    public static void endAddVertexData(ftv wrr, int vertexCount) {
        SVertexBuilder svb = wrr.sVertexBuilder;
        if (svb.vertexSize == 18 && wrr.getDrawMode() == VertexFormat.b.h && wrr.getVertexCount() % 4 == 0) {
            SVertexBuilder.endSetVertexFormat((ftv)wrr);
            int indexEnd = vertexCount * svb.vertexSize;
            for (int index = 0; index < indexEnd; index += svb.vertexSize * 4) {
                svb.calcNormal(wrr, index);
            }
        }
    }

    public void calcNormal(ftv wrr, int baseIndex) {
        FloatBuffer floatBuffer = wrr.getFloatBuffer();
        IntBuffer intBuffer = wrr.getIntBuffer();
        float v0x = floatBuffer.get((baseIndex += wrr.getIntStartPosition()) + 0 * this.vertexSize);
        float v0y = floatBuffer.get(baseIndex + 0 * this.vertexSize + 1);
        float v0z = floatBuffer.get(baseIndex + 0 * this.vertexSize + 2);
        float v0u = floatBuffer.get(baseIndex + 0 * this.vertexSize + this.offsetUV);
        float v0v = floatBuffer.get(baseIndex + 0 * this.vertexSize + this.offsetUV + 1);
        float v1x = floatBuffer.get(baseIndex + 1 * this.vertexSize);
        float v1y = floatBuffer.get(baseIndex + 1 * this.vertexSize + 1);
        float v1z = floatBuffer.get(baseIndex + 1 * this.vertexSize + 2);
        float v1u = floatBuffer.get(baseIndex + 1 * this.vertexSize + this.offsetUV);
        float v1v = floatBuffer.get(baseIndex + 1 * this.vertexSize + this.offsetUV + 1);
        float v2x = floatBuffer.get(baseIndex + 2 * this.vertexSize);
        float v2y = floatBuffer.get(baseIndex + 2 * this.vertexSize + 1);
        float v2z = floatBuffer.get(baseIndex + 2 * this.vertexSize + 2);
        float v2u = floatBuffer.get(baseIndex + 2 * this.vertexSize + this.offsetUV);
        float v2v = floatBuffer.get(baseIndex + 2 * this.vertexSize + this.offsetUV + 1);
        float v3x = floatBuffer.get(baseIndex + 3 * this.vertexSize);
        float v3y = floatBuffer.get(baseIndex + 3 * this.vertexSize + 1);
        float v3z = floatBuffer.get(baseIndex + 3 * this.vertexSize + 2);
        float v3u = floatBuffer.get(baseIndex + 3 * this.vertexSize + this.offsetUV);
        float v3v = floatBuffer.get(baseIndex + 3 * this.vertexSize + this.offsetUV + 1);
        float y1 = v2y - v0y;
        float z2 = v3z - v1z;
        float y2 = v3y - v1y;
        float z1 = v2z - v0z;
        float vnx = y1 * z2 - y2 * z1;
        float x2 = v3x - v1x;
        float x1 = v2x - v0x;
        float vny = z1 * x2 - z2 * x1;
        float vnz = x1 * y2 - x2 * y1;
        float lensq = vnx * vnx + vny * vny + vnz * vnz;
        float mult = (double)lensq != 0.0 ? (float)(1.0 / Math.sqrt(lensq)) : 1.0f;
        vnx *= mult;
        vny *= mult;
        vnz *= mult;
        x1 = v1x - v0x;
        y1 = v1y - v0y;
        z1 = v1z - v0z;
        float u1 = v1u - v0u;
        float v1 = v1v - v0v;
        x2 = v2x - v0x;
        y2 = v2y - v0y;
        z2 = v2z - v0z;
        float u2 = v2u - v0u;
        float v2 = v2v - v0v;
        float d2 = u1 * v2 - u2 * v1;
        float r = d2 != 0.0f ? 1.0f / d2 : 1.0f;
        float tan1x = (v2 * x1 - v1 * x2) * r;
        float tan1y = (v2 * y1 - v1 * y2) * r;
        float tan1z = (v2 * z1 - v1 * z2) * r;
        float tan2x = (u1 * x2 - u2 * x1) * r;
        float tan2y = (u1 * y2 - u2 * y1) * r;
        float tan2z = (u1 * z2 - u2 * z1) * r;
        lensq = tan1x * tan1x + tan1y * tan1y + tan1z * tan1z;
        mult = (double)lensq != 0.0 ? (float)(1.0 / Math.sqrt(lensq)) : 1.0f;
        tan1x *= mult;
        tan1y *= mult;
        tan1z *= mult;
        lensq = tan2x * tan2x + tan2y * tan2y + tan2z * tan2z;
        mult = (double)lensq != 0.0 ? (float)(1.0 / Math.sqrt(lensq)) : 1.0f;
        float tan3x = vnz * tan1y - vny * tan1z;
        float tan3y = vnx * tan1z - vnz * tan1x;
        float tan3z = vny * tan1x - vnx * tan1y;
        float tan1w = (tan2x *= mult) * tan3x + (tan2y *= mult) * tan3y + (tan2z *= mult) * tan3z < 0.0f ? -1.0f : 1.0f;
        int bnx = (int)(vnx * 127.0f) & 0xFF;
        int bny = (int)(vny * 127.0f) & 0xFF;
        int bnz = (int)(vnz * 127.0f) & 0xFF;
        int packedNormal = (bnz << 16) + (bny << 8) + bnx;
        intBuffer.put(baseIndex + 0 * this.vertexSize + this.offsetNormal, packedNormal);
        intBuffer.put(baseIndex + 1 * this.vertexSize + this.offsetNormal, packedNormal);
        intBuffer.put(baseIndex + 2 * this.vertexSize + this.offsetNormal, packedNormal);
        intBuffer.put(baseIndex + 3 * this.vertexSize + this.offsetNormal, packedNormal);
        int packedTan1xy = ((int)(tan1x * 32767.0f) & 0xFFFF) + (((int)(tan1y * 32767.0f) & 0xFFFF) << 16);
        int packedTan1zw = ((int)(tan1z * 32767.0f) & 0xFFFF) + (((int)(tan1w * 32767.0f) & 0xFFFF) << 16);
        intBuffer.put(baseIndex + 0 * this.vertexSize + 11, packedTan1xy);
        intBuffer.put(baseIndex + 0 * this.vertexSize + 11 + 1, packedTan1zw);
        intBuffer.put(baseIndex + 1 * this.vertexSize + 11, packedTan1xy);
        intBuffer.put(baseIndex + 1 * this.vertexSize + 11 + 1, packedTan1zw);
        intBuffer.put(baseIndex + 2 * this.vertexSize + 11, packedTan1xy);
        intBuffer.put(baseIndex + 2 * this.vertexSize + 11 + 1, packedTan1zw);
        intBuffer.put(baseIndex + 3 * this.vertexSize + 11, packedTan1xy);
        intBuffer.put(baseIndex + 3 * this.vertexSize + 11 + 1, packedTan1zw);
        float midU = (v0u + v1u + v2u + v3u) / 4.0f;
        float midV = (v0v + v1v + v2v + v3v) / 4.0f;
        floatBuffer.put(baseIndex + 0 * this.vertexSize + 9, midU);
        floatBuffer.put(baseIndex + 0 * this.vertexSize + 9 + 1, midV);
        floatBuffer.put(baseIndex + 1 * this.vertexSize + 9, midU);
        floatBuffer.put(baseIndex + 1 * this.vertexSize + 9 + 1, midV);
        floatBuffer.put(baseIndex + 2 * this.vertexSize + 9, midU);
        floatBuffer.put(baseIndex + 2 * this.vertexSize + 9 + 1, midV);
        floatBuffer.put(baseIndex + 3 * this.vertexSize + 9, midU);
        floatBuffer.put(baseIndex + 3 * this.vertexSize + 9 + 1, midV);
        if (Shaders.useVelocityAttrib) {
            VertexPosition[] vps = wrr.getQuadVertexPositions();
            int frameId = Config.getWorldRenderer().getFrameCount();
            this.setVelocity(floatBuffer, baseIndex, 0, vps, frameId, v0x, v0y, v0z);
            this.setVelocity(floatBuffer, baseIndex, 1, vps, frameId, v1x, v1y, v1z);
            this.setVelocity(floatBuffer, baseIndex, 2, vps, frameId, v2x, v2y, v2z);
            this.setVelocity(floatBuffer, baseIndex, 3, vps, frameId, v3x, v3y, v3z);
            wrr.setQuadVertexPositions(null);
        }
        if (wrr.getVertexFormat() == fty.b) {
            Vector3f mb = wrr.getMidBlock();
            float mbx = mb.x();
            float mby = mb.y();
            float mbz = mb.z();
            this.setMidBlock(intBuffer, baseIndex, 0, mbx - v0x, mby - v0y, mbz - v0z);
            this.setMidBlock(intBuffer, baseIndex, 1, mbx - v1x, mby - v1y, mbz - v1z);
            this.setMidBlock(intBuffer, baseIndex, 2, mbx - v2x, mby - v2y, mbz - v2z);
            this.setMidBlock(intBuffer, baseIndex, 3, mbx - v3x, mby - v3y, mbz - v3z);
        }
    }

    public void setMidBlock(IntBuffer intBuffer, int baseIndex, int vertex, float mbx, float mby, float mbz) {
        int imbx = (int)(mbx * 64.0f) & 0xFF;
        int imby = (int)(mby * 64.0f) & 0xFF;
        int imbz = (int)(mbz * 64.0f) & 0xFF;
        int packedMidBlock = (imbz << 16) + (imby << 8) + imbx;
        intBuffer.put(baseIndex + vertex * this.vertexSize + 8, packedMidBlock);
    }

    public void setVelocity(FloatBuffer floatBuffer, int baseIndex, int vertex, VertexPosition[] vps, int frameId, float x, float y, float z2) {
        float vx = 0.0f;
        float vy = 0.0f;
        float vz = 0.0f;
        if (vps != null && vps.length == 4) {
            VertexPosition vp2 = vps[vertex];
            vp2.setPosition(frameId, x, y, z2);
            if (vp2.isVelocityValid()) {
                vx = vp2.getVelocityX();
                vy = vp2.getVelocityY();
                vz = vp2.getVelocityZ();
            }
        }
        int offset = baseIndex + vertex * this.vertexSize + 15;
        floatBuffer.put(offset + 0, vx);
        floatBuffer.put(offset + 1, vy);
        floatBuffer.put(offset + 2, vz);
    }

    public static void calcNormalChunkLayer(ftv wrr) {
        if (wrr.getVertexFormat().hasNormal() && wrr.getDrawMode() == VertexFormat.b.h && wrr.getVertexCount() % 4 == 0) {
            SVertexBuilder svb = wrr.sVertexBuilder;
            SVertexBuilder.endSetVertexFormat((ftv)wrr);
            int indexEnd = wrr.getVertexCount() * svb.vertexSize;
            for (int index = 0; index < indexEnd; index += svb.vertexSize * 4) {
                svb.calcNormal(wrr, index);
            }
        }
    }

    public static boolean preDrawArrays(VertexFormat vf) {
        int vertexSizeByte = vf.getVertexSize();
        if (vertexSizeByte != 72) {
            return false;
        }
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)vertexSizeByte, (long)36L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)vertexSizeByte, (long)44L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)vertexSizeByte, (long)52L);
        GL20.glVertexAttribPointer((int)Shaders.velocityAttrib, (int)3, (int)5126, (boolean)false, (int)vertexSizeByte, (long)60L);
        GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.velocityAttrib);
        return true;
    }

    public static void postDrawArrays() {
        GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
        GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
        GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        GL20.glDisableVertexAttribArray((int)Shaders.velocityAttrib);
    }
}

